%% Function to create opendx models from obj polygos - G.A. Jun 2009 / ARUPLIGHTING
% Current version: v.1.0.3
% What's new:  v.1.0.3 Swap switch c4d required (1 = yes)
% What's new:  v.1.0.2 Corrected bug where files with no triangles did crash the converter
% mind that swapping of Z - Y is performed in the function load_obj_quads_c4d
% if you need to change this behavious edit lines 197 and 199 in file load_obj_quads_c4d
function obj2odx(file)
disp('USAGE: obj2odx(''file.obj'')');
disp('REMEMBER: obj2odx requires that obj file contains materials');
disp('REMEMBER: also each vertex should e used in a polygon!');


% setting to swap cinema 4D coordinates or not%%%%%
% 1 = yes
c4d = 1;
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

vertex =3;
[PP,QQ3, E]=load_obj_quads_c4d(file,vertex,c4d);
%how many quads?
n_pol3 = size(QQ3,1)/3;
%cycle for each quad
for i = 1 : n_pol3
% get starting coordinates for grid
starting_point =  QQ3(3*(i-1)+1,1:3);
second_point =    QQ3(3*(i-1)+2,1:3);
last_point =      QQ3(3*(i-1)+3,1:3);
% generates versors for grid
versore_i = (second_point - starting_point);
versore_j = (last_point   - starting_point);
% generate normal and spray over grid
N3 = (cross(versore_i,versore_j)) / norm(cross(versore_i,versore_j));
normals3(i,1:3) = N3;
end

vertex =4;
[PP,QQ4, E]=load_obj_quads_c4d(file,vertex,c4d);
%how many quads?
n_pol4 = size(QQ4,1)/4;
%cycle for each quad
for i = 1 : n_pol4
% get starting coordinates for grid
starting_point =  QQ4(4*(i-1)+1,1:3);
second_point =    QQ4(4*(i-1)+2,1:3);
opposite_corner = QQ4(4*(i-1)+3,1:3);
last_point =      QQ4(4*(i-1)+4,1:3);
% generates versors for grid
versore_i = (second_point - starting_point);
versore_j = (last_point   - starting_point);
% generate normal and spray over grid
N4 = (cross(versore_i,versore_j)) / norm(cross(versore_i,versore_j));
normals4(i,1:3) = N4;
end

if(isempty(QQ3) == 0 && isempty(QQ4) == 0)
position_list = [QQ3; QQ4];
edge_list = [0:(size(position_list,1)-1)]';

LL3 = [0:3:(n_pol3-1)*3]';
LL4 = [(n_pol3-1)*3+2+1:4:(n_pol3-1)*3+2+(n_pol4)*4]';
loop_list = [LL3;LL4];

face_list = [0:(n_pol3+n_pol4-1)]';
color_list = repmat([0.5 0.5 0.5],n_pol3+n_pol4,1);
normal_list = [normals3;normals4];

object = ones(n_pol3+n_pol4,1);
end




if(isempty(QQ3) == 1)
position_list = [QQ4];
edge_list = [0:(size(position_list,1)-1)]';

LL4 = [0:4:(n_pol4)*4-1]';
loop_list = [LL4];

face_list = [0:(n_pol4-1)]';
color_list = repmat([0.5 0.5 0.5],n_pol4,1);
normal_list = [normals4];

object = ones(n_pol4,1);
end

if(isempty(QQ4) == 1)
position_list = [QQ3];
edge_list = [0:(size(position_list,1)-1)]';

LL3 = [0:3:(n_pol3-1)*3]';
loop_list = [LL3];

face_list = [0:(n_pol3-1)]';
color_list = repmat([0.5 0.5 0.5],n_pol3,1);
normal_list = [normals3];

object = ones(n_pol3,1);
end









filedx = fopen('converted.dx','w');



fprintf(filedx,'object "position list" class array type float rank 1 shape 3 items %d data follows\n',size(position_list,1));

for i = 1:size(position_list,1)
fprintf(filedx,'%f %f %f\n',position_list(i,:));
end


fprintf(filedx,'object "edge list" class array type int rank 0 items %d data follows\n',size(edge_list,1));


for i = 1:size(edge_list,1)
fprintf(filedx,'%d\n',edge_list(i,:));
end




fprintf(filedx,'attribute "ref" string "positions"\n');

fprintf(filedx,'object "loop list" class array type int rank 0 items %d data follows\n',size(loop_list,1));


for i = 1:size(loop_list,1)
fprintf(filedx,'%d\n',loop_list(i,:));
end


fprintf(filedx,'attribute "ref" string "edges"\n');

fprintf(filedx,'object "face list" class array type int rank 0 items %d data follows\n',size(face_list,1));

for i = 1:size(face_list,1)
fprintf(filedx,'%d\n',face_list(i,:));
end


fprintf(filedx,'attribute "ref" string "loops"\n');

fprintf(filedx,'object "color list" class array type float rank 1 shape 3 items %d data follows\n',size(color_list,1));



for i = 1:size(color_list,1)
fprintf(filedx,'%f %f %f\n',color_list(i,:));
end




fprintf(filedx,'attribute "dep" string "faces"\n');


fprintf(filedx,'object "normal list" class array type float rank 1 shape 3 items %d data follows\n',size(normal_list,1));


for i = 1:size(normal_list,1)
fprintf(filedx,'%f %f %f\n',normal_list(i,:));
end




fprintf(filedx,'attribute "dep" string "faces"\n');


fprintf(filedx,'object 1 class array type float rank 0 items %d data follows\n',size(face_list,1));

for i = 1:size(object,1)
fprintf(filedx,'%d\n',object(i,:));
end


fprintf(filedx,'attribute "dep" string "faces"\n');
fprintf(filedx,'object "solid" class field\n');
fprintf(filedx,'component "positions" "position list"\n');
fprintf(filedx,'component "edges" "edge list"\n');
fprintf(filedx,'component "loops" "loop list"\n');
fprintf(filedx,'component "faces" "face list"\n');
fprintf(filedx,'component "colors" "color list"\n');
fprintf(filedx,'component "normals" "normal list"\n');
fprintf(filedx,'component "opacities" value 1\n')

fclose(filedx);

disp('File converted! Look for converted.dx.');

end
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
















%% Function to import an obj - G.A. Jun 2009 / ARUPLIGHTING
% swithch to export also quads - for grid generation
% Current version: v.1.0.4
% What's new: Obj importer accepts rhino obj with UV in 2D                v.1.0.4
% What's new: Obj also requires the c4d flag to swap coordinates 1 = yes  v.1.0.4
% What's new: Obj importer is adapted for gridify and obj2odx. v.1.0.3
% What's new: Obj importer with now reporting error if obj file is not there. v.1.0.1
% Heavily based on previous work by:
% W.S. Harwin, University Reading, 2006
% See also Anders Sandberg's vertface2obj.m and saveobjmesh.m
% This modified version exports vertex coordinates and UV coordinates for triangles.


function [PP,QQ, E]=load_obj_quads_c4d(file,vertex,c4d)
%file = 'test.obj';
%vertex =4;



if nargin <1 
  disp('specify model name')  
end


V = [];
VT = [];

F3v = [];
F3t = [];

F4v = [];
F4t = [];
%%
% Output is:
%
% * VT, coorfinate for textures
% * V, coordinate for vertex
% * F3v, connections for triangles
% * F4t, connections for UV triangles
% * F4v, connection for quads
% * F4t, connection for UV quads
%
% 

%%
% open and scan the file with format and get cell array with the 13 values
%file = 'testUV2.obj';
fid = fopen(file,'r');
if (fid<0) error(['Can not open the .obj file: ' file]);end


%%
% define some counters
vnum=1;
f3num=1;
f4num=1;
vtnum=1;
vnum=1;
gnum=1;

%%
% Scan lines which are not empty
cline=fgets(fid);
while cline>=0
  cline = deblank(cline);
  cline = deblank(cline);
  cline = deblank(cline);
  s = sscanf(cline,'%s',1);
  l=length(cline);
  if l==0  
%%
% Line is  empty 
    %disp(['empty' cline]);
  end

%%
% if the line is not empty start reading file for different cases:
    switch s
%%
% These are comments
    case '#' 
        %disp(['Skipping: ' cline]);
%%
% These are vertexes and are collected into V
      case 'v' 
          v=sscanf(cline(2:l),'%f');      
          V(:,vnum)=v;      
          vnum=vnum+1;
%%
% textures
      case 'vt' 
%%
% scan from char 3 to L, end of line
         vt=sscanf(cline(3:l),'%f');      
         VT(:,vtnum)=vt;      
         vtnum=vtnum+1;
%%       
% mesh or nurbs, just ignore
      case 'g'       
            %disp(['Skipping: ' cline]);
%%
% Material of object, this need improvement
%%
% *NOTE: NOW ALL WORKS ONLY WITH ONLY ONE MATERIAL*
      case 'usemtl' 
            %disp(['Skipping: ' cline]);
%%
% Normals - ignored
        case 'vn'      
    %disp(['Skipping: ' cline]);
        
%%
% Faces
        case 'f' 
%%
% remove trailing zeros
      cline=deblank(cline(3:l));
%%
% count spaces, add one = vertexes
      nvrts=length(findstr(cline,' '))+1;
%%
% count slashes
      fstr=findstr(cline,'/');
      nslash=length(fstr);

      if nvrts == 3
%%
% Case with vertex and textures
         if nslash ==3
%%
% scan for vertex
             f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5]);
%%
% scan for UV vertex
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 6]);
%%
% case with vertex, textures and normals,
        elseif nslash==6  
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7]);
          f2=sscanf(cline,'%f/%f/%f');         
          f2=f2([2 5 8]);
         elseif nslash==0
          f1=sscanf(cline,'%f');
        else
          %disp(['xyx' cline])
          f1=[];
          f2=[];
         end
%%
% The output for vertex connections
        F3v(:,f3num)=f1;
        F3t(:,f3num)=f2;
        f3num=f3num+1;
      
      
%%
% Same but for quads, which are not supported by the Radiance
% interface
      elseif nvrts == 4
        if nslash == 4
          f1=sscanf(cline,'%f/%f');
          f1=f1([1 3 5 7]);
          f2=sscanf(cline,'%f/%f');
          f2=f2([2 4 5 8]);
        elseif nslash == 8
          f1=sscanf(cline,'%f/%f/%f');
          f1=f1([1 4 7 10]);
          f2=sscanf(cline,'%f/%f/%f');
          f2=f2([2 6 8 11]);
        elseif nslash ==0
          f1=sscanf(cline,'%f');
        else
          %disp(['xx' cline])
          f1=[];
          f2=[];
        end
        F4v(:,f4num)=f1;
        F4t(:,f4num)=f2;
        f4num=f4num+1;
      end 
     
    otherwise 
      if ~strcmp(cline,char([13 10]))
        %disp(['Unprocessed: ' cline]);
      end
    end
     
       cline=fgets(fid);
end

fclose(fid);


if(c4d == 1)
%cinema 4d and swap of axes
PER = [1 0 0; 0 0 -1; 0 1 0];
disp('Swapping coordinates Z-Y. Cinema4D ready.')
end

if(c4d == 0)
%standard axis
PER = [1 0 0; 0 1 0; 0 0 1];
disp('Coordinates unchanged. No Z-Y swapping.')
end


%this fixes when textures have just x y and not z coordinates...
%bloody rhino...
if(size(VT,1) == 2)
VT(3,:) = 0;
end

PP_4 = VT(1:3,F4t)';
QQ0_4 = V(1:3,F4v)';
QQ1_4 = PER*QQ0_4';
QQ_4 = QQ1_4';

PP_3 = VT(1:3,F3t)';
QQ0_3 = V(1:3,F3v)';
QQ1_3 = PER*QQ0_3';
QQ_3 = QQ1_3';

if (vertex == 4)
PP = PP_4;
QQ=QQ_4;
end


if (vertex == 3)
PP = PP_3;
QQ=QQ_3;
end



E = 0;
if (isempty(PP)==1) 
E = 1;
end

end




